=begin
Copyright 2013, Chris Fullmer
All Rights Reserved

Disclaimer
THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

License
This software is distributed under the Smustard End User License Agreement
http://www.smustard.com/eula

Information
Author - Chris Fullmer
Organization - www.ChrisFullmer.com and distributed on the Extension Warehouse
Name - Shape Bender
SU Version - 2013, 8, 7

Description
This plugin will bend a group or component to match an existing cruve.

Usage
Create a shape to bend.  It must be a group or a component.  Then select a single horizontal 
(red axis) line to use as the base for bending.  Then select the curve that the shape will bend 
to match.  Wait for it to think, then it will show a grid and preview of where your object is going 
to transform to.  Press the UP Arrow key to toggle the orientation of the bend.

History
0.1 Beta:: 2009-04-08
   * Original release.  I'm expecting plenty of bugs and feedback.
0.2 Beta:: 2009-04-09
   * Now will bend components (and still bends groups).
   * Works when the shape to bend is comprised of components and groups by exploding all the groups and components inside.
   * Does not explode the shape at any point (thats very good!)
   * Works with scaled and/or rotated components
   * Added line and arc highlighting to indicate when you move the mouse over an acceptable selection for the line or the arc
   * Fixed a bug where selecting a closed loop would hang the plugin.  Now it gives an error.
0.25 Beta:: 2009-04-10
   * Hit the down arrow key to change the start/end positions of the line.  The line needs to have its start point "to the left" of the endpoint...  If you notice weird behavior in how the shape is lining up to be bent, try hitting the down arrow key.
   * Up arrow key AND Home hey toggle the curve.  Downd arrow key AND End toggle the line now for added compatibility (for BTM :)
0.3 Beta:: 2009-04-10
   * Added a check to disable the up and down keys until the correct selections have been made.
   * Added more checks to make sure that the line and curve being selected are acceptable selections.  Pops up messageboxes letting you know if your selection was invalid.
   * Now it leaves a component where the original group/component was located.  It remains mostly untouched, but it might get a name change.
0.5 Beta:: 2009-04-11
   * Added a toolbar and icon
   * Added new mouse pointers that sort of hint at what you should be trying to click on next
   * Fixed the bug where the bent shape would not appear smoothed until you double clicked on it.  Should look good now immediately after bending.
   * Added extensions support so this plugin can be turned off through the extensions manager.
   * Added Progressbar.rb support.  It is now required.  Get it at smustard.com
0.51 Beta:: 2009-04-11
   * Made the icon transparent
   * Fixed a Mac toolbar visibility state remembering problem
0.55 Beta:: 2010-04-21
   * Minor touchups on script syntax.
   * Tweaked a few things to make the script a little faster
0.6.0 beta
  * Updated to be EW compatible
  * Integrated Progressbar into the script so it is no longer required.
0.6.1 beta 2013-05-06
  * Fixed menu compatibility with older clf scripts  
=end


module CLF_Extensions_NS
  
  module CLF_Shape_Bender            #EDIT
    require 'sketchup.rb'
    require 'extensions.rb'
    
    NAME = "clf_shape_bender"        #EDIT
    UNAME = "CLF Shape Bender"       #EDIT
    MENU_NAME = "Shape Bender"       #EDIT
    version = "0.6.1 beta"           #EDIT
    desc = "This plugin will bend a group or component to match an existing cruve."
    copy_year = "2013"
    author = "Chris Fullmer"
    
#------edit above--------------------------------------------------------------- 

    
    extension = SketchupExtension.new UNAME, NAME+"/"+NAME+"_menus.rb"

    #The name= method sets the name which appears for an extension inside the Extensions Manager dialog.
    extension.name = UNAME

    # The description= method sets the long description which appears beneath an extension inside the Extensions Manager dialog.
    extension.description = desc + "  Access it via Plugins > Chris Fullmer Tools > "+MENU_NAME

    # The version method sets the version which appears beneath an extension inside the Extensions Manager dialog.
    extension.version = version

    # Create an entry in the Extension list that loads a script called
    # stairTools.rb.
    extension.copyright = copy_year
     
    # The creator= method sets the creator string which appears beneath an extension inside the Extensions Manager dialog.
    extension.creator = author

    # The register_extension method is used to register an extension with SketchUp's extension manager (in SketchUp preferences).
    Sketchup.register_extension( extension, true )
    
  end
end